/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/


/**
 * \file    DM814x_EVM.c
 *
 * \brief   Generic routines for DM814x EVM
 *
 * This file contains the generic routines for test codes for EVM.
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_types.h"
#include "DM814x_EVM.h"

#include "stdio.h"
/*
 *====================
 * Static declarations
 *====================
 */

 /*
 *====================
 * Function implementations
 *====================
 */
/** **************************************************************************
 * \n \brief Routine to initialize the DM814x EVM board
 *
 * This routine initializes the DM814x EVM Base Board
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
STATUS DM814x_EVM_Init (void)
{
	printf ("Test Suite version number is %d.%d.\r\n", MAJOR_VERSION, MINOR_VERSION);
	printf ("Build Date =  %s : Time = %s.\r\n", __DATE__, __TIME__);
	return (SUCCESS);
}

/** **************************************************************************
 * \n \brief Delay loop used for Micro-second delay
 *
 * Delay loop used for Micro-second delay
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
void DM814x_wait
( 
	UINT32 u32Delay 
)
{
    volatile UINT32 u32LoopCntr;
    for ( u32LoopCntr = 0 ; u32LoopCntr < u32Delay ; u32LoopCntr++ ){ };
}


/** **************************************************************************
 * \n \brief Micro-second delay routine
 *
 * Utility routine for micro-seconds
 * 
 * \param  u32usec	[IN] 	Delay in micro-seconds
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
void DM814x_usecDelay 
( 
	UINT32 u32usec 
)
{
    #ifdef ARM_SIDE
        DM814x_wait( u32usec * 2 );
    #elif DSP_SIDE
        DM814x_wait( u32usec * 28 );
    #endif
    DM814x_wait( u32usec * 2 );
}
